/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.registry;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.registry.CraftingTweaksRegistrationData;
import net.blay09.mods.craftingtweaks.registry.DataDrivenGridFactory;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_7654;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyJsonCompatLoader
implements class_4013 {
    private static final Logger logger = LoggerFactory.getLogger(LegacyJsonCompatLoader.class);
    private static final Gson gson = new Gson();
    private static final class_7654 COMPAT_JSONS = class_7654.method_45114((String)"craftingtweaks_compat");
    private final List<CraftingGridProvider> providersFromDataPacks = new ArrayList<CraftingGridProvider>();

    public void method_14491(class_3300 resourceManager) {
        for (CraftingGridProvider craftingGridProvider : this.providersFromDataPacks) {
            CraftingTweaksAPI.unregisterCraftingGridProvider(craftingGridProvider);
        }
        this.providersFromDataPacks.clear();
        for (Map.Entry entry : COMPAT_JSONS.method_45113(resourceManager).entrySet()) {
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    CraftingGridProvider gridProvider = LegacyJsonCompatLoader.load((class_2960)entry.getKey(), (CraftingTweaksRegistrationData)gson.fromJson((Reader)reader, CraftingTweaksRegistrationData.class));
                    if (gridProvider == null) continue;
                    this.providersFromDataPacks.add(gridProvider);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                logger.error("Parsing error loading CraftingTweaks data file at {}", entry.getKey(), (Object)e);
            }
        }
    }

    private static boolean isCompatEnabled(String modId) {
        return !CraftingTweaksConfig.getActive().client.disabledAddons.contains(modId);
    }

    private static CraftingGridProvider load(class_2960 resourceId, CraftingTweaksRegistrationData data) {
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !Balm.isModLoaded((String)modId) || !LegacyJsonCompatLoader.isCompatEnabled(modId) || !data.isEnabled()) {
            return null;
        }
        CraftingGridProvider gridProvider = DataDrivenGridFactory.createGridProvider(data);
        if (gridProvider != null) {
            CraftingTweaksAPI.registerCraftingGridProvider(gridProvider);
            logger.info("Data pack file {} has registered {} of {} with CraftingTweaks", new Object[]{resourceId, data.getContainerClass(), modId});
        }
        return gridProvider;
    }
}

